/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


/*

*/

var STBLayoutScroller				= Object.create(STBModule.prototype);
	STBLayoutScroller.name			= "LayoutScroller";
	STBLayoutScroller.script			= site.assets + "plugins/fullpage.js/plugin.js";


STBLayoutScroller.isActive = function() {

	if (jQuery("body").attr("data-scroll-page") != "true") {
		return false;
	}

	return true;
}


STBLayoutScroller.startScript = function() {
	if (STBLayoutScroller.isActive()) {
		STBUtils.loadScriptCallback(
			STBLayoutScroller.script,
			STBLayoutScroller.initPlugin,
			true
		);
	}
}


STBLayoutScroller.initialize = function() {
	if (!STBLayoutScroller.isActive()) {
		return false;
	}

	//no diagonal edges for blocks
	STBBackgrounds.angleDisable();
	//menu is sticky all the time
	STBHeader.toggleSticky(true);

	STBBackgrounds.menuRemoveEffects();

	//remove all ctas outside the <main> tag

	//footer its not collapsable
	STBFooter.collapseFooter(false);
	//remove topintro if exists
	STBModuleTopintro.disable();

	jQuery(".page-header").remove();
	jQuery(".page-header").addClass("fp-auto-height");

}

STBLayoutScroller.initPlugin = function() {

	if (!STBLayoutScroller.isActive()) {
		return false;
	}


	if (jQuery("body > footer > section").length){

		jQuery("body > main").append(jQuery("body > footer"));
		jQuery("footer").addClass("fp-auto-height");
	}

	var anchors = [],
		navigation = [],
		cnt=0;
		

	jQuery("main > section, main > footer").each(function() {
		cnt ++;

		jQuery(this).addClass("full-page vertical-align-center").removeClass("half-page");

		if (jQuery(this).hasClass("full-page")) {
		} else {
			jQuery(this).addClass("fp-auto-height");
		}

		var menu = jQuery(this).attr("data-scroll-menu")

		if (typeof menu !== typeof undefined && menu !== false) {
			navigation.push(menu);
			anchors.push(jQuery(this).attr("data-scroll-menu-anchor"));
		} else {
			navigation.push("");
			anchors.push("section-" + cnt);
		}
	});


	options = {
		sectionSelector: ' > *',
		verticalCentered: false,
		autoScrolling: true,
		_fixedElements: ".wrapper",
		normalScrollElements: ".wrapper",
		scrollOverflow: true,
	};

	if (jQuery("body").attr("data-scroll-menu") == "true") {
		options["navigation"] = true;
		options["anchors"] = anchors;
		options["navigationTooltips"] = navigation;
		options["navigationPosition"] = jQuery("body").attr("data-scroll-menu-pos");
	}

	jQuery("main").fullpage(options);


	//$("main").css 

}

STBLayoutScroller.configureSite = function() {	

}


STBLayoutScroller.runOnReady = function() {
	STBLayoutScroller.startScript();
}

STBLayoutScroller.runOnLoad = function() {
	if (!site.onepage) {
		//STBLayoutScroller.initPlugin();
	}
}

STBLayoutScroller.runOnContentUpdate = function() {
	if (site.onepage) {
		//STBLayoutScroller.initPlugin();
	}	
}

STBLayoutScroller.runOnResize = function() {

}

site.registerModule(STBLayoutScroller);